//+------------------------------------------------------------------+
//|                                                     C_Orders.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include "C_Terminal.mqh"
//+------------------------------------------------------------------+
class C_Orders : protected C_Terminal
{
	protected:
//+------------------------------------------------------------------+
inline const ulong GetMagicNumber(void) const { return m_MagicNumber; }
//+------------------------------------------------------------------+
		void RemoveOrderPendent(const ulong ticket)
			{
				ZeroMemory(m_TradeRequest);
				m_TradeRequest.action 	= TRADE_ACTION_REMOVE;
				m_TradeRequest.order		= ticket;
				ToServer();
			};
//+------------------------------------------------------------------+
	private	:
//+------------------------------------------------------------------+
		MqlTradeRequest	m_TradeRequest;
		ulong					m_MagicNumber;
//+------------------------------------------------------------------+
		ulong ToServer(void)
			{
				MqlTradeCheckResult 	TradeCheck;
				MqlTradeResult    	TradeResult;
				bool bTmp;
				
				ResetLastError();
				ZeroMemory(TradeCheck);
				ZeroMemory(TradeResult);
				bTmp = OrderCheck(m_TradeRequest, TradeCheck);
				if (_LastError == ERR_SUCCESS) bTmp = OrderSend(m_TradeRequest, TradeResult);
				if (_LastError != ERR_SUCCESS) MessageBox(StringFormat("Error Number: %d", GetLastError()), "Order System", MB_OK);
				return (_LastError == ERR_SUCCESS ? TradeResult.order : 0);
			}
//+------------------------------------------------------------------+
inline void CommonData(const ENUM_ORDER_TYPE type, const double Price, const double FinanceStop, const double FinanceTake, const uint Leverage, const bool IsDayTrade)
			{
				double Desloc;
				
				ZeroMemory(m_TradeRequest);
				m_TradeRequest.magic				= m_MagicNumber;
				m_TradeRequest.symbol			= _Symbol;
				m_TradeRequest.volume			= NormalizeDouble(GetTerminalInfos().VolMinimal + (GetTerminalInfos().VolStep * (Leverage - 1)), GetTerminalInfos().nDigits);
				m_TradeRequest.price				= NormalizeDouble(Price, GetTerminalInfos().nDigits);
				Desloc = FinanceToPoints(FinanceStop, Leverage);
				m_TradeRequest.sl					= NormalizeDouble(Desloc == 0 ? 0 : Price + (Desloc * (type == ORDER_TYPE_BUY ? -1 : 1)), GetTerminalInfos().nDigits);
				Desloc = FinanceToPoints(FinanceTake, Leverage);
				m_TradeRequest.tp					= NormalizeDouble(Desloc == 0 ? 0 : Price + (Desloc * (type == ORDER_TYPE_BUY ? 1 : -1)), GetTerminalInfos().nDigits);
				m_TradeRequest.type_time		= (IsDayTrade ? ORDER_TIME_DAY : ORDER_TIME_GTC);
				m_TradeRequest.stoplimit		= 0;
				m_TradeRequest.expiration		= 0;
				m_TradeRequest.type_filling	= ORDER_FILLING_RETURN;
				m_TradeRequest.deviation		= 1000;
				m_TradeRequest.comment			= "Order Generated by Experts Advisor.";
			}
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_Orders(const ulong magic)
			:C_Terminal(), m_MagicNumber(magic)
			{ }
//+------------------------------------------------------------------+	
		~C_Orders() { }
//+------------------------------------------------------------------+
		ulong CreateOrder(const ENUM_ORDER_TYPE type, const double Price, const double FinanceStop, const double FinanceTake, const uint Leverage, const bool IsDayTrade)
			{
				double 	bid, ask;
				
				bid = SymbolInfoDouble(_Symbol, (GetTerminalInfos().ChartMode == SYMBOL_CHART_MODE_LAST ? SYMBOL_LAST : SYMBOL_BID));
				ask = (GetTerminalInfos().ChartMode == SYMBOL_CHART_MODE_LAST ? bid : SymbolInfoDouble(_Symbol, SYMBOL_ASK));
				CommonData(type, AdjustPrice(Price), FinanceStop, FinanceTake, Leverage, IsDayTrade);
				m_TradeRequest.action	= TRADE_ACTION_PENDING;
				m_TradeRequest.type		= (type == ORDER_TYPE_BUY ? (ask >= Price ? ORDER_TYPE_BUY_LIMIT : ORDER_TYPE_BUY_STOP) : 
																					 (bid < Price ? ORDER_TYPE_SELL_LIMIT : ORDER_TYPE_SELL_STOP));				
				
				return (((type == ORDER_TYPE_BUY) || (type == ORDER_TYPE_SELL)) ? ToServer() : 0);
			};
//+------------------------------------------------------------------+	
		ulong ToMarket(const ENUM_ORDER_TYPE type, const double FinanceStop, const double FinanceTake, const uint Leverage, const bool IsDayTrade)
			{
				CommonData(type, SymbolInfoDouble(_Symbol, (type == ORDER_TYPE_BUY ? SYMBOL_ASK : SYMBOL_BID)), FinanceStop, FinanceTake, Leverage, IsDayTrade);
				m_TradeRequest.action	= TRADE_ACTION_DEAL;
				m_TradeRequest.type		= type;

				return (((type == ORDER_TYPE_BUY) || (type == ORDER_TYPE_SELL)) ? ToServer() : 0);
			};
//+------------------------------------------------------------------+	
		bool ModifyPricePoints(const ulong ticket, const double Price, const double PriceStop, const double PriceTake)
			{
				ZeroMemory(m_TradeRequest);
				m_TradeRequest.symbol	= _Symbol;
				if (OrderSelect(ticket))
				{
					m_TradeRequest.action		= (Price > 0 ? TRADE_ACTION_MODIFY : TRADE_ACTION_REMOVE);
					m_TradeRequest.order			= ticket;
					if (Price > 0)
					{
						m_TradeRequest.price			= NormalizeDouble(AdjustPrice(Price), GetTerminalInfos().nDigits);
						m_TradeRequest.sl				= NormalizeDouble(AdjustPrice(PriceStop), GetTerminalInfos().nDigits);
						m_TradeRequest.tp				= NormalizeDouble(AdjustPrice(PriceTake), GetTerminalInfos().nDigits);
						m_TradeRequest.type_time	= (ENUM_ORDER_TYPE_TIME)OrderGetInteger(ORDER_TYPE_TIME) ;
						m_TradeRequest.expiration	= 0;
					}
				}else if (PositionSelectByTicket(ticket))
				{
					m_TradeRequest.action		= TRADE_ACTION_SLTP;
					m_TradeRequest.position		= ticket;
					m_TradeRequest.tp				= NormalizeDouble(AdjustPrice(PriceTake), GetTerminalInfos().nDigits);
					m_TradeRequest.sl				= NormalizeDouble(AdjustPrice(PriceStop), GetTerminalInfos().nDigits);
				}else return false;
				ToServer();
				
				return (_LastError == ERR_SUCCESS);
			};
//+------------------------------------------------------------------+	
		bool ClosePosition(const ulong ticket, const uint partial = 0)
			{
				double v1 = partial * GetTerminalInfos().VolMinimal, Vol;
				bool IsBuy;
				
				if	(!PositionSelectByTicket(ticket)) return false;
				IsBuy = PositionGetInteger(POSITION_TYPE) == POSITION_TYPE_BUY;
				Vol = PositionGetDouble(POSITION_VOLUME);
				ZeroMemory(m_TradeRequest);
				m_TradeRequest.action		= TRADE_ACTION_DEAL;
				m_TradeRequest.type			= (IsBuy ? ORDER_TYPE_SELL : ORDER_TYPE_BUY);
				m_TradeRequest.price			= SymbolInfoDouble(_Symbol, (IsBuy ? SYMBOL_BID : SYMBOL_ASK));
				m_TradeRequest.position		= ticket;
				m_TradeRequest.symbol		= _Symbol;
				m_TradeRequest.volume		= ((v1 == 0) || (v1 > Vol) ? Vol : v1);
				m_TradeRequest.deviation	= 1000;
				ToServer();
 				
				return (_LastError == ERR_SUCCESS);
			};
//+------------------------------------------------------------------+	
};
//+------------------------------------------------------------------+
